/*
 * File: MagneticPoetry.java
 * ================================================================
 * A program that simulates magnetic poetry.
 */
import acm.program.*;
import acm.graphics.*;
import acm.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class MagneticPoetry extends GraphicsProgram {
	/* Size the window to be appropriately large. */
	public static final int APPLICATION_WIDTH = 1000;
	public static final int APPLICATION_HEIGHT = 600;
	
	/* Where we should get our words from. */
	private static final String WORDS_FILE = "karel-words.txt";
	
	/* Sets up the world and initializes mouse listeners. */
	public void run() {
		addMagneticWords();
		addMouseListeners();
	}
	
	/**
	 * Adds the magnetic words to the display.
	 */
	private void addMagneticWords() {
		try {
			/* Open the words file for processing. */
			BufferedReader br = new BufferedReader(new FileReader(WORDS_FILE));
			
			/* Keep reading from the file until we run out of words. */
			while (true) {
				String line = br.readLine();
				if (line == null) break;
				
				/* Display the given word. */
				addWord(line);
			}
			
			br.close();
		} catch (IOException e) {
			addWord("Sad Times");
		}
	}
	
	/**
	 * Adds the given word to the display.
	 * 
	 * @param word The word to add
	 */
	private void addWord(String word) {
		GLabel text = new GLabel(word);
		text.setFont("DejaVuSerif-BOLD-24");
		
		/* Construct a new compound to hold the text and a backing. */
		GCompound magnet = new GCompound();
		text.setLocation(0, text.getAscent());
		magnet.add(text);
		
		GRect rect = new GRect(0, 0, text.getWidth(), text.getHeight());
		magnet.add(rect);
		
		/* Choose a random location for the magnet. */
		RandomGenerator rgen = RandomGenerator.getInstance();
		double x = rgen.nextDouble(0, getWidth() - magnet.getWidth());
		double y = rgen.nextDouble(0, getHeight() - magnet.getHeight());
		magnet.setLocation(x, y);
	
		
		/* Add the text to the display. */
		add(magnet);
	}
	
	/* The currently-selected object, or null if nothing is
	 * selected.
	 */
	private GObject selected = null;
	
	/* The X and Y coordinates of where the mouse last was. */
	private double lastX;
	private double lastY;
	
	/**
	 * When the mouse is pressed, select the appropriate object.
	 */
	public void mousePressed(MouseEvent e) {
		/* See what we hit. */
		selected = getElementAt(e.getX(), e.getY());
		
		/* Track the X and Y coordinates of the mouse. */
		lastX = e.getX();
		lastY = e.getY();
	}
	
	/**
	 * When the mouse is released, deselect the current object.
	 */
	public void mouseReleased(MouseEvent e) {		
		selected = null;
	}
	
	/**
	 * When the mouse is dragged, move the selected object along
	 * with the mouse.
	 */
	public void mouseDragged(MouseEvent e) {
		if (selected != null) {
			/* See how much the mouse moved. */
			double dx = e.getX() - lastX;
			double dy = e.getY() - lastY;
			
			/* Update the position of the selected object. */
			selected.move(dx, dy);
			
			/* Update the X and Y coordinate for the mouse. */
			lastX = e.getX();
			lastY = e.getY();
		}
	}
}
